//=============================================================================
// SpinnerCarcass.
//=============================================================================
class Carcass_Spinner expands CreatureCarcass;

#exec mesh IMPORT MESH=SpinnerHead ANIVFILE=Models\Enemies\Spinner\SpinnerHead_a.3D DATAFILE=Models\Enemies\Spinner\SpinnerHead_d.3D X=0 Y=0 Z=0
#forceexec MESH ORIGIN MESH=SpinnerHead X=0 Y=0 Z=-20 YAW=-64
#exec MESH SEQUENCE MESH=SpinnerHead SEQ=All    STARTFRAME=0   NUMFRAMES=2
#exec MESH SEQUENCE MESH=SpinnerHead SEQ=Still  STARTFRAME=0   NUMFRAMES=2
#exec texture IMPORT NAME=JGSpinner1  FILE=Textures\Enemies\Spinner\JGSpinner1.bmp FAMILY=Skins FLAGS=2
#exec texture IMPORT NAME=JGSpinner2  FILE=Textures\Enemies\Spinner\JGSpinner2.bmp GROUP=Skins PALETTE=JGSpinner1 // head4T6y
#exec MESHMAP NEW   MESHMAP=SpinnerHead MESH=SpinnerHead
#exec MESHMAP SCALE MESHMAP=SpinnerHead X=0.04 Y=0.04 Z=0.08
#exec MESHMAP SETTEXTURE MESHMAP=SpinnerHead NUM=0 TEXTURE=JGSpinner1
#exec MESHMAP SETTEXTURE MESHMAP=SpinnerHead NUM=1 TEXTURE=JGSpinner2

#exec mesh IMPORT MESH=SpinnerBody ANIVFILE=Models\Enemies\Spinner\SpinnerBody_a.3D DATAFILE=Models\Enemies\Spinner\SpinnerBody_d.3D X=0 Y=0 Z=0
#forceexec MESH ORIGIN MESH=SpinnerBody X=0 Y=0 Z=0 YAW=-64
#exec MESH SEQUENCE MESH=SpinnerBody SEQ=All    STARTFRAME=0   NUMFRAMES=2
#exec MESH SEQUENCE MESH=SpinnerBody SEQ=Still  STARTFRAME=0   NUMFRAMES=2
#exec MESHMAP NEW   MESHMAP=SpinnerBody MESH=SpinnerBody
#exec MESHMAP SCALE MESHMAP=SpinnerBody X=0.04 Y=0.04 Z=0.08
#exec MESHMAP SETTEXTURE MESHMAP=SpinnerBody NUM=0 TEXTURE=JGSpinner1

#exec mesh IMPORT MESH=SpinnerClaw ANIVFILE=Models\Enemies\Spinner\SpinnerClaw_a.3d DATAFILE=Models\Enemies\Spinner\SpinnerClaw_d.3d X=0 Y=0 Z=0
#forceexec MESH ORIGIN MESH=SpinnerClaw X=0 Y=0 Z=0 YAW=-64
#exec MESH SEQUENCE MESH=SpinnerClaw SEQ=All         STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=SpinnerClaw SEQ=SpinnerClaw STARTFRAME=0 NUMFRAMES=2
#exec MESHMAP NEW   MESHMAP=SpinnerClaw MESH=SpinnerClaw
#exec MESHMAP SCALE MESHMAP=SpinnerClaw X=0.04 Y=0.04 Z=0.08
#exec MESHMAP SETTEXTURE MESHMAP=SpinnerClaw NUM=0 TEXTURE=JGSpinner1

#exec MESH IMPORT MESH=SpinnerLeg1 ANIVFILE=Models\Enemies\Spinner\SpinnerLeg1_a.3D DATAFILE=Models\Enemies\Spinner\SpinnerLeg1_d.3D X=0 Y=0 Z=0
#forceexec MESH ORIGIN MESH=SpinnerLeg1 X=0 Y=0 Z=0 YAW=-64
#exec MESH SEQUENCE MESH=SpinnerLeg1 SEQ=All    STARTFRAME=0   NUMFRAMES=2
#exec MESH SEQUENCE MESH=SpinnerLeg1 SEQ=Still  STARTFRAME=0   NUMFRAMES=2
#exec MESHMAP NEW   MESHMAP=SpinnerLeg1 MESH=SpinnerLeg1
#exec MESHMAP SCALE MESHMAP=SpinnerLeg1 X=0.04 Y=0.04 Z=0.08
#exec MESHMAP SETTEXTURE MESHMAP=SpinnerLeg1 NUM=0 TEXTURE=JGSpinner1

#exec MESH IMPORT MESH=SpinnerLeg2 ANIVFILE=Models\Enemies\Spinner\SpinnerLeg2_a.3D DATAFILE=Models\Enemies\Spinner\SpinnerLeg2_d.3D X=0 Y=0 Z=0
#forceexec MESH ORIGIN MESH=SpinnerLeg2 X=0 Y=0 Z=0 YAW=-64
#exec MESH SEQUENCE MESH=SpinnerLeg2 SEQ=All    STARTFRAME=0   NUMFRAMES=2
#exec MESH SEQUENCE MESH=SpinnerLeg2 SEQ=Still  STARTFRAME=0   NUMFRAMES=2
#exec MESHMAP NEW   MESHMAP=SpinnerLeg2 MESH=SpinnerLeg2
#exec MESHMAP SCALE MESHMAP=SpinnerLeg2 X=0.04 Y=0.04 Z=0.08
#exec MESHMAP SETTEXTURE MESHMAP=SpinnerLeg2 NUM=0 TEXTURE=JGSpinner1

#exec mesh IMPORT MESH=SpinnerLeg3 ANIVFILE=Models\Enemies\Spinner\SpinnerLeg3_a.3D DATAFILE=Models\Enemies\Spinner\SpinnerLeg3_d.3D X=0 Y=0 Z=0
#forceexec MESH ORIGIN MESH=SpinnerLeg3 X=0 Y=0 Z=0 YAW=-64
#exec MESH SEQUENCE MESH=SpinnerLeg3 SEQ=All    STARTFRAME=0   NUMFRAMES=2
#exec MESH SEQUENCE MESH=SpinnerLeg3 SEQ=Still  STARTFRAME=0   NUMFRAMES=2
#exec MESHMAP NEW   MESHMAP=SpinnerLeg3 MESH=SpinnerLeg3
#exec MESHMAP SCALE MESHMAP=SpinnerLeg3 X=0.04 Y=0.04 Z=0.08
#exec MESHMAP SETTEXTURE MESHMAP=SpinnerLeg3 NUM=0 TEXTURE=JGSpinner1

#exec MESH IMPORT MESH=SpinnerLeg4 ANIVFILE=Models\Enemies\Spinner\SpinnerLeg4_a.3D DATAFILE=Models\Enemies\Spinner\SpinnerLeg4_d.3D X=0 Y=0 Z=0
#forceexec MESH ORIGIN MESH=SpinnerLeg4 X=0 Y=0 Z=0 YAW=-64
#exec MESH SEQUENCE MESH=SpinnerLeg4 SEQ=All    STARTFRAME=0   NUMFRAMES=2
#exec MESH SEQUENCE MESH=SpinnerLeg4 SEQ=Still  STARTFRAME=0   NUMFRAMES=2
#exec MESHMAP NEW   MESHMAP=SpinnerLeg4 MESH=SpinnerLeg4
#exec MESHMAP SCALE MESHMAP=SpinnerLeg4 X=0.04 Y=0.04 Z=0.08
#exec MESHMAP SETTEXTURE MESHMAP=SpinnerLeg4 NUM=0 TEXTURE=JGSpinner1

#exec mesh IMPORT MESH=SpinnerTail ANIVFILE=Models\Enemies\Spinner\SpinnerTail_a.3D DATAFILE=Models\Enemies\Spinner\SpinnerTail_d.3D X=0 Y=0 Z=0
#forceexec MESH ORIGIN MESH=SpinnerTail X=0 Y=0 Z=0 YAW=-64
#exec MESH SEQUENCE MESH=SpinnerTail SEQ=All    STARTFRAME=0   NUMFRAMES=2
#exec MESH SEQUENCE MESH=SpinnerTail SEQ=Still  STARTFRAME=0   NUMFRAMES=2
#exec MESHMAP NEW   MESHMAP=SpinnerTail MESH=SpinnerTail
#exec MESHMAP SCALE MESHMAP=SpinnerTail X=0.04 Y=0.04 Z=0.08
#exec MESHMAP SETTEXTURE MESHMAP=SpinnerTail NUM=0 TEXTURE=JGSpinner2

function InitFor( actor Other )
{
	Super.InitFor( Other );
	if( AnimSequence == 'Death5' )
		bodyparts[7]=None;
}

defaultproperties
{
    bodyparts(0)=LodMesh'SpinnerBody'
    bodyparts(1)=LodMesh'SpinnerTail'
    bodyparts(2)=LodMesh'SpinnerLeg1'
    bodyparts(3)=LodMesh'SpinnerLeg2'
    bodyparts(4)=LodMesh'SpinnerLeg3'
    bodyparts(5)=LodMesh'SpinnerLeg4'
    bodyparts(6)=LodMesh'SpinnerClaw'
    bodyparts(7)=LodMesh'SpinnerHead'
    ZOffset(1)=0.75
    ZOffset(2)=0.25
    ZOffset(3)=0.25
    ZOffset(4)=0.25
    ZOffset(5)=0.25
    ZOffset(7)=0.50
    bGreenBlood=True
    AnimSequence=Death
    Mesh=LodMesh'Spinner'
    CollisionRadius=32.00
    CollisionHeight=22.00
    Mass=100.00
    Buoyancy=100.00
}
